import { world } from "@minecraft/server";
import { AntHillBlock } from "../block/AntHillBlock";
import { ChrysalisBlock } from "../block/Chrysalis";
import { old_chrysalis_update } from "../block/Chrysalis.old";
import { AntiVenomPotion } from "../item/AntiVenom";
import { FatItem } from "../item/Fat";
import { ToothDagger } from "../item/ToothDagger";
import { StinkyBalloon } from "../item/StinkyBalloon";
import { QueenAnt } from "../item/QueenAnt";
import '../block/FurnaceBlock';
export class Register {
  constructor() {
    Register.#registerBlockEvents();
    Register.#registerItemEvents();
  }
  static #registerBlockEvents() {
    world.beforeEvents.worldInitialize.subscribe((e) => {
      e.blockComponentRegistry.registerCustomComponent(AntHillBlock.COMPONENT_ID, new AntHillBlock());
      e.blockComponentRegistry.registerCustomComponent(ChrysalisBlock.COMPONENT_ID, new ChrysalisBlock());
      e.blockComponentRegistry.registerCustomComponent('sf_nba:old_chrysalis_update', { onTick: old_chrysalis_update });
    });
  }
  static #registerItemEvents() {
    world.beforeEvents.worldInitialize.subscribe((e) => {
      e.itemComponentRegistry.registerCustomComponent("sf_nba:tooth_dagger", new ToothDagger());
      e.itemComponentRegistry.registerCustomComponent("sf_nba:stinky_balloon", new StinkyBalloon());
      e.itemComponentRegistry.registerCustomComponent("sf_nba:fat", new FatItem());
      e.itemComponentRegistry.registerCustomComponent("sf_nba:antivenom_potion", new AntiVenomPotion());
      e.itemComponentRegistry.registerCustomComponent("sf_nba:queen_ant", new QueenAnt());
    });
  }
}
new Register();